//=============================================================================
// Wallhook1, not really a hook though.
//=============================================================================
class GunChest extends DeusExDecoration;

var bool bOpen, bOpening, bOpenPush;
var float RiseTime, RiseTimer;
var Weapon Items[2];
var vector ItemOffsets[2], DefaultItemOffsets[2];
var rotator ItemRotations[2];
var int WeaponLevel;

#exec MESH IMPORT MESH=WeaponBox ANIVFILE=MODELS\BorderlandsWepBox_a.3d DATAFILE=MODELS\BorderlandsWepBox_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WeaponBox X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=WeaponBox SEQ=All              STARTFRAME=0 NUMFRAMES=9
#exec MESH SEQUENCE MESH=WeaponBox SEQ=WeaponBox STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WeaponBox SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WeaponBox SEQ=Open STARTFRAME=0 NUMFRAMES=9 RATE=3

#exec MESHMAP NEW   MESHMAP=WeaponBox MESH=WeaponBox
#exec MESHMAP SCALE MESHMAP=WeaponBox X=0.042970125 Y=0.042970125 Z=0.042970125

#exec TEXTURE IMPORT FILE="Textures\WeaponBoxRedAlloy.pcx"	NAME="WeaponBoxRedAlloy"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxGrayAlloy.pcx"	NAME="WeaponBoxGrayAlloy"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxGreenLight.pcx"	NAME="WeaponBoxGreenLight"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxRedLight.pcx"	NAME="WeaponBoxRedLight"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxDGrayAlloy.pcx"	NAME="WeaponBoxDGrayAlloy"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxSilverAlloy.pcx"	NAME="WeaponBoxSilverAlloy"				GROUP="Icons" MIPS=Off


#exec MESHMAP SETTEXTURE MESHMAP=WeaponBox NUM=0 TEXTURE=WeaponBoxRedAlloy
#exec MESHMAP SETTEXTURE MESHMAP=WeaponBox NUM=1 TEXTURE=WeaponBoxGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=WeaponBox NUM=2 TEXTURE=WeaponBoxGreenLight
#exec MESHMAP SETTEXTURE MESHMAP=WeaponBox NUM=3 TEXTURE=WeaponBoxDGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=WeaponBox NUM=4 TEXTURE=WeaponBoxSilverAlloy


#exec OBJ LOAD FILE=MoverSFX

//=================================
//Motion Notes
//=================================
//7.2 units in holder elevation, starts 2.66 seconds in, takes 0.33 seconds

function Frob(Actor Frobber, Inventory FrobWith)
{
 if (bOpen || bOpening) return;
 
 bOpening = True;
 Multiskins[2] = Texture'WeaponBoxRedLight';

 PlaySound(Sound'MachineDoor4');
 PlayAnim('Open');
 SetTimer(RiseTime, False);
}

/*function UpdateGunLevels()
{
 Items[0].SetPropertyText("WeaponLevel", String(WeaponLevel + Rand(4)));
 Items[1].SetPropertyText("WeaponLevel", String(WeaponLevel + Rand(4)));
 
 if (Items[0].IsA('BorderlandsWeapon')) BorderlandsWeapon(Items[0]).RandomizeStats();
 if (Items[1].IsA('BorderlandsWeapon')) BorderlandsWeapon(Items[1]).RandomizeStats();
}*/

function class<Weapon> RandomGunType()
{
 local int r;
 
 if (Frand() > 0.02)
 {
 
 r = rand(7);
 
 if (r == 0) return class'RandomShotgun';
 if (r == 1) return class'RandomSniper';
 if (r == 2) return class'RandomRepeater';
 if (r == 3) return class'RandomRevolver';
 if (r == 4) return class'RandomCobra';
 if (r == 5) return class'RandomMachineGun';
 if (r == 6) return class'RandomSMG';
 
 }
 else
 {
  return UniqueWeapon();
 }
}

function class<Weapon> UniqueWeapon()
{
 local int r;
 
 r = rand(9);
 
 BroadcastMessage("|p4Unique Weapon Has Spawned!");
 
 if (r == 0) return class'AtlasUnique';
 if (r == 1) return class'DahlUnique';
 if (r == 2) return class'HyperionUnique';
 if (r == 3) return class'JakobsUnique';
 if (r == 4) return class'MaliwanUnique';
 if (r == 5) return class'SnsUnique';
 if (r == 6) return class'TedioreUnique';
 if (r == 7) return class'TorgueUnique';
 if (r == 8) return class'VladofUnique';
}

function UpdateGunLevels()
{
 local int R, R2;
 
 if (Items[0] != None || Items[1] != None) return;
 
 if (WeaponLevel < 1) WeaponLevel = 1;
 
 R = WeaponLevel;
 R2 = WeaponLevel;
 
 if (Frand() < 0.1) R = WeaponLevel + Rand(3) + 1;
 if (Frand() < 0.1) R2 = WeaponLevel + Rand(3) + 1;
 
 if (R > 50) R = 50;
 if (R2 > 50) R2 = 50;
 
 Items[0] = Spawn(randomguntype());
 Items[1] = Spawn(randomguntype());
 
 Items[0].SetPropertyText("WeaponLevel", String(R));
 Items[1].SetPropertyText("WeaponLevel", String(R2));
 
 if (Items[0].IsA('BorderlandsWeapon')) BorderlandsWeapon(Items[0]).RandomizeStats();
 if (Items[1].IsA('BorderlandsWeapon')) BorderlandsWeapon(Items[1]).RandomizeStats();

 if (InStr(CAPS(Items[0].ItemName), "|P7") > -1) BroadcastMessage("|p7Pearlscent Weapon Has Spawned!");
 if (InStr(CAPS(Items[1].ItemName), "|P7") > -1) BroadcastMessage("|p7Pearlscent Weapon Has Spawned!");

 Items[0].SetPhysics(PHYS_None);
 Items[1].SetPhysics(PHYS_None);
 
 ItemOffsets[0] = DefaultItemOffsets[0];
 ItemOffsets[1] = DefaultItemOffsets[1];
}

function Tick(float DT)
{
 Super.Tick(DT);
 
 if (bOpenPush && RiseTimer < 0.33333)
 {
  RiseTimer += DT;
  
  ItemOffsets[0].Z = DefaultItemOffsets[0].Z + (8.2 * (RiseTimer / 0.333));
  ItemOffsets[1].Z = DefaultItemOffsets[1].Z + (8.2 * (RiseTimer / 0.333));
 }
 
 if (Items[0] != None)
 {
  Items[0].SetLocation(Location + (ItemOffsets[0] >> Rotation));
  Items[0].SetRotation(Rotation + ItemRotations[0]);

  if (RiseTimer < 0.33333)
  {
   Items[0].SetCollisionSize(0,0);
  }
  if (RiseTimer >= 0.33333)
  {
   Items[0].SetCollisionSize(Items[0].Default.CollisionRadius,Items[0].Default.CollisionHeight);
   Items[0] = None; //disown them for when the player drops a gun
  }
 }
 if (Items[1] != None)
 {
  Items[1].SetLocation(Location + (ItemOffsets[1] >> Rotation));
  Items[1].SetRotation(Rotation + ItemRotations[1]);

  if (RiseTimer < 0.33333)
  {
   Items[1].SetCollisionSize(0,0);
  }
  if (RiseTimer >= 0.33333)
  {
   Items[1].SetCollisionSize(Items[1].Default.CollisionRadius,Items[1].Default.CollisionHeight);
   Items[1] = None;
  }
 }
}

function Timer()
{
 bOpenPush = True;
}

defaultproperties
{
     bInvincible=True
     bFlammable=False
     Flammability=0.000000
     MinDamageThreshold=65536
     bPushable=False
     ItemName="Weapons Chest"
     Mesh=LodMesh'WeaponBox'
     CollisionRadius=32.500000
     CollisionHeight=11.000000
     Mass=0.000000
     Buoyancy=0.000000
     //Physics=PHYS_None
     bBlockPlayers=True
     bBlockActors=True
     bCollideActors=True
     bProjTarget=True
     bHighlight=True
     bCanBeBase=True
     Drawscale=0.500000

     DefaultItemOffsets(0)=(X=-4.000000,Y=-8.000000,Z=2.826000)
     DefaultItemOffsets(1)=(X=4.000000,Y=8.000000,Z=2.826000)
     RiseTime=2.20
}
